<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'amount',
        'fee',
        'dr_cr',
        'type',
        'method',
        'date',
        'created_user_id',
        'note',
        'transaction_details'
    ];

    /**
     * Define a belongs to relationship with the Membership model, with a default value.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function membership()
    {
        return $this->belongsTo(Membership::class)->withDefault();
    }

    /**
     * Define a morph to relationship for the Transaction model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function transactionable()
    {
        return $this->morphTo()->withDefault();
    }
}